# Whileループ
`while` ループと `True` と `False` の値をアンロックしました。`while` ループは、条件が `True` である限りループ本体を実行し続けます。

`while condition:
	#ループ本体`

無限ループを作成することを心配しないでください。実行の遅延がプログラムのフリーズを防ぎます。

## 初心者向け
すでに行に複数の `harvest()` 呼び出しを並べてみたかもしれません:

`harvest()
harvest()
harvest()`

これにより、1回のプログラム実行で複数回収穫できます。
しかし、3回以上収穫できるといいですし、同じコードを何度も書くのは悪い習慣です。
解決策はループです。
ループを使用すると、同じコードを複数回実行できます。

whileループは条件を取ります。これは `True` または `False` の2つの状態のいずれかしか取れない論理値です。
このような値はブール値と呼ばれます。

ループは、条件がFalseになるまでループ内のコードを実行します。
whileループは次のようになります:

`while condition:
	#ループ本体
	#ループ本体
	#...`
	
ここで "condition" をブール値に、`#loop body` をループ内で行いたいことに置き換える必要があります。

利用可能な定数のブール値は2つあります。定数はプログラム中に決して変わらない値です。

常に `True` である定数のブール値を作成するには、単に `True` と書きます。常に `False` である定数のブール値としては `False` と書きます。
したがって、次のように書くことができます


`while False:
	do_a_flip()`

または

`while True:
	do_a_flip()`

最初のものは決してフリップを行わず、2番目のものは永遠にフリップを行います（無限ループ）。

通常、無限ループを作成するのはプログラムがフリーズするため悪い考えですが、このゲームではループの各反復の間に遅延があるため、実行ボタンをもう一度押して手動で停止するまでドローンはフリップを続けます。

コロンの後の行がインデントされていることに注目してください。このようなインデントはコードのブロックを区切るために使用されます。
Tabキーを押してインデントを追加し、Shift + Tab（またはBackspace）で削除します。

ループはコロンの後のすべてのインデントされたステートメントを繰り返します。
インデントされたブロックの後のステートメントは、ループが終了した後に実行されます。
